Phaser {

	*help { arg method, argument;
		^Switch(method.asSymbol)
			.case(\note, {"\nWritten by CK 1/3/02. first version"})
			.case(\short_desc, {"Phaser with phase argument"})
			.case(\long_desc, {"Sawtooth oscillator. Output ranges from (0 to mul starting at phase) + add."})
			.caseIncludes([\ar,\kr],{
				Switch(argument.asSymbol)
					.case( 'freq', {"frequency in Hertz"} )
					.case( 'phase', {"starting phase (between 0 and mul)"} )
					.case( 'mul', {"maximum value"} )
					.result
			})
			.case(\examples, {"\nEXAMPLES:\n"
"\n(\nSynth.plot({ Phaser.ar( 500, 0.5, 1 ) })\n)"			
"\n\n(\nSynth.plot({ Phaser.ar( 500, 1, 2 ).fold2(1) })\n)"			
			})
			.case(\nil,{HELP(this)})
			.resultStr
	}
	
	*kr { arg freq = 440.0, phase=0, mul = 1.0, add = 0.0;
		var halfmul;
		halfmul = mul/2;
		^LFSaw.kr( freq, halfmul, mul + phase ).wrap2(halfmul) + halfmul + add;
	}
	*ar { arg freq = 440.0, phase=0, mul = 1.0, add = 0.0;
		var halfmul;
		halfmul = mul/2;
		^LFSaw.ar( freq, halfmul, mul + phase ).wrap2(halfmul) + halfmul + add;
	}
}
